# Simulation graphique du jeu de carte "La Bataille"

from tkinter import *
from ex7_9 import *        # importation du module contenant la simulation du jeu de cartes

class Application(Tk):
    """Définition de l'application principale tkinter permettant
    d'interagir avec l'utilisateur. Cette application contient un
    canevas et quelques boutons"""

    def __init__(self):
        "Construction de l'interface graphique"

        Tk.__init__(self)
        self.title("La Bataille")

        # Commutateur du jeu:
        self.flag = 0                   # etat du jeu (0=arrêt / 1=jeu en cours)
        self.compteEchanges = 12        # compte à rebours des échanges
        
        # Création du canevas 
        self.can = Canvas(self, bg = 'dark green', height = 269, width = 400)
        self.can.grid(row = 1, column = 1, rowspan = 4, columnspan = 4, padx = 5, pady = 5)
        self.ImgTapis = PhotoImage(file="images/Tapis.gif")
        self.nettoyerTapis()

        # Création de la zone de textes
        self.affichage = Label(self, text="BIENVENUE A LA BATAILLE !", width=37, bg = 'black', fg='white', font=("Comic sans Ms", "12"))
        self.affichage.grid(row=4, column=1, columnspan=4)
        
        # Création des boutons
        Button(self, text = "Distribuer", width = 8, command = self.distribuer).grid(row = 5, column = 1)
        Button(self, text = "Jouer !", width = 8, command = self.jouer).grid(row = 5, column = 2)
        Button(self, text = "Surplus", width = 8, command = self.afficher).grid(row = 5, column = 3)
        Button(self, text = "Quitter", width = 8, command = self.quit).grid(row = 5, column = 4)


    def nettoyerTapis(self):
        "Prépare le tapis de jeu pour une nouvelle partie"

        self.can.delete(ALL)        # efface l'ensemble des éléments situés sur le canevas
        self.can.create_image(200, 134, image=self.ImgTapis)


    def distribuer(self):
        "Lancer la partie en distribuant les cartes au deux joueurs"

        if self.flag == 0:  # début d'une nouvelle partie
            self.flag = 1

            # Préparation pour la nouvelle partie:
            self.nettoyerTapis()

            # Initialisation des paramètres de configuration du jeu:
            self.jeu = Jeu()                # Instanciation d'un jeu de cartes
            self.joueurA = Main()           # Instanciation du joueur A
            self.joueurB = Main()           # Instanciation du joueur B
            self.points = {'A':0, 'B':0}    # Initialisation des points des joueurs
            self.compteEchanges = 12        # Initialisation du compte à rebours des échanges

            # Mélange du jeu de cartes:
            self.jeu.battre()

            # Distribution de 18 cartes à chaque joueur:
            for i in range(18):
                self.joueurA.ajouter(self.jeu.tirer())

            for i in range(18):
                self.joueurB.ajouter(self.jeu.tirer())

            # Affichage des points dans 2 étiquettes de texte:
            self.pointsA = Label(self, text="Joueur A:\n"+str(self.points['A']), width=8, bg='black', fg='white', font=("Comic sans Ms", "12"))
            self.pointsA.grid(row = 1, column = 1)

            self.pointsB = Label(self, text="Joueur B:\n"+str(self.points['B']), width=8, bg='black', fg='white', font=("Comic sans Ms", "12"))
            self.pointsB.grid(row = 1, column = 4)
            
            # Afficher l'action:
            self.affichage.configure(text="Les cartes sont distribuées !")

        else:
            # Afficher l'action:
            self.affichage.configure(text="Les cartes ont déjà été distribuées !")
        
        
    def jouer(self):
        "Tire une carte de chaque main, les compare et affiche le vainqueur"

        # Cette méthode ne peut etre appelée que si le jeu a commencé
        # et que le nombre d'échanges n'a pas encore dépassé 12.
        # Si on se trouve dans une partie, la méthode doit opérer ainsi:
        # 1) Tirer une carte chez chaque joueur
        # 2) Afficher les images des cartes tirées sur le tapis de jeu
        # 3) Comparer les cartes jouées, incrémenter le compteur du gagnant
        # et afficher le résultat de la comparaison dans le label self.affichage
        # 4) Mettre à jour le label de compteur de points de chaque joueur
        # Si la partie se termine, la méthode doit le signaler dans le label
        # self.affichage et arrêter le jeu
        

    def afficher(self):
        "Créer deux fenêtres secondaires affichant les cartes restantes de chaque joueur"

        if self.flag == 0 and self.compteEchanges == 0:
            self.fenA = Secondaire(self, 'A')
            self.fenB = Secondaire(self, 'B')
            
        else:
            self.affichage.configure(text="Attendez la fin du jeu !")
            

class Secondaire(Toplevel):
    """Définition d'une fenêtre secondaire permettant
    d'afficher les résultats de chaque joueur"""

    def __init__(self, application, joueur):

        # A compléter
        # le constructeur récupère le reste des cartes du <joueur>
        # associé, les trie et les affiche dans un canevas en dessus
        # d'un tapis de jeu

        
 
# Programme principal

jeu = Application()
jeu.mainloop()
jeu.destroy()
