# -*- encoding:utf8 -*-

# Classes simulant un jeu de cartes standard

from random import *
from tkinter import *

class Carte(object):
    "Représente une carte traditionnelle"

    # Attributs de classe communs à toutes les instances de la classe

    Valeurs = {6:'6', 7:'7', 8:'8', 9:'9', 10:'10', 11:'Valet', 12:'Dame', 13:'Roi', 14:'As'}
    Couleurs = ['Coeur', 'Carreau', 'Trefle', 'Pique']

    def __init__(self, val = 6, coul = 0):
        "Initialise une carte particulière"

        if 6 <= val <= 14 and 0 <= coul <= 3:
            self.valeur = val
            self.couleur = coul
        else:
            self.valeur = 6
            self.couleur = 0

        self.img = PhotoImage(file='images/'+Carte.Valeurs[self.valeur]+Carte.Couleurs[self.couleur]+'.gif')
            
    def __str__(self):
        "Surcharge la fonction print"

        return '{} de {}'.format(Carte.Valeurs[self.valeur], Carte.Couleurs[self.couleur])


    def __lt__(self, autre):
        """
        Surcharge l'opérateur <
        Retourne True si la valeur de <self> est plus petite que la valeur de <autre>,
        False sinon"""

        if self.valeur < autre.valeur:
            return True
        else:
            return False

    def __gt__(self, autre):
        """
        Surcharge l'opérateur <
        Retourne Tru si la valeur de <self> est plus grande que la valeur de <autre>,
        False sinon"""

        if self.valeur > autre.valeur:
            return True
        else:
            return False

    def __eq__(self, autre):
        """
        Surcharge l'opérateur ==
        Retourne True si la valeur de <self> est égale à la valeur de <autre>,
        False sinon"""

        if self.valeur == autre.valeur:
            return True
        else:
            return False


class Jeu(object):
    "Représente un jeu de cartes traditionnel"

    def __init__(self):
        "Initialise le jeu de cartes"
        self.cartes = []                            # un jeu est symbolisé par une liste de cartes
        for valeur in range(6, 15):
            for couleur in range(4):
                carte = Carte(valeur, couleur)
                self.cartes.append(carte)

    def tirer(self):
        "Tire la première carte du jeu"
        n = len(self.cartes)
        if n > 0:                                   # si le jeu n'est pas vide
            carte = self.cartes[-1]
            del(self.cartes[-1])
            return carte
        else:
            return 0                                # signifie que le jeu est vide

    def battre(self):
        "Mélange les cartes de manière aléatoire"
        n = len(self.cartes)
        for k in range(n):
            i, j = randrange(n), randrange(n)
            self.cartes[i], self.cartes[j] = self.cartes[j], self.cartes[i]


class Main(Jeu):
    "Représente une main composée de cartes"

    def __init__(self):
        self.cartes = []

    def ajouter(self, carte):
        "Ajouter une carte à la main"
        self.cartes.append(carte)

    def trier(self):
        "Trie les cartes de manière croissante"

        self.cartes.sort()
