# -*- encoding:utf-8

# Programme simulant une partie de tennis

from tkinter import *
from random import randint

# Visuellement, le résultat doit être aussi proche du modèle que possible

class Application(Tk):
    """Définition de la classe principale créant un terrain de tennis
    contenant deux raquettes gérées par les joueurs et plusieurs balles
    rebondissant contre les parois du terrain.
    """

    def __init__(self): # 5 pts
        """Construction de l'interface graphique"""

        # Création du titre de la fenêtre
        Tk.__init__(self)
        self.title("Wimbledon 2019")

        # Création et positionnement de l'étiquette des points (initialisé à "Bienvenus à Wimbledon")
        # en Comic sans Ms de taille 14, en jaune sur fond violet
        self.affichagePoints = 

        # Création et positionnement (à droite de l'aire de jeu) de la zone d'inscription contenant,
        # pour chaque joueur, les éléments suivants:
        #   1 étiquette de texte "Joueur i" (i = 1, 2)
        #   1 zone de texte initialisée à "Federer" pour joueur 1 et "Djokovic" pour joueur 2
    
        self.etiquette1 = 
    
        self.zone1 = 
    
        self.etiquette2 = 

        self.zone2 = 


        # Création et positionnement de l'étiquette de texte contenant les informations
        # relatives au déroulement du jeu (initialisée à "Entrez le nom des joueurs dans les
        # zones de texte") en Comic sans Ms de taille 14 et de couleur rouge:
        self.message = 


        # Création et positionnement du bouton de démarrage géré par la méthode <play>:
        self.interrupteur =

        # Création et positionnement du bouton d'arrêt géré par la méthode <destroy>:


        # Création et positionnement du terrain de tennis de 400 px de large et 252 de haut
        # avec fond vert foncé, 2 lignes horizontales blanches de 5 px d'épais et 1 ligne
        # verticale blanche centrée de 5 px d'épais en traitillé 4px + 4px:
        self.can = 

        # Création des raquettes dont le mouvement vertical est géré par la combinaison des touches
        # <w>/<x> pour celle du joueur 1 et <Up>/<Down> pour celle du joueur 2:
        self.joueur1 = 
        self.joueur2 = 

        # Références aux balles du jeu:
        self.balles = []
        self.balles.append(Balle(self))

        # Gestionnaire d'animation du jeu:
        self.flag = -1

        # Valeur du chronomètre:
        self.temps = 0

        
    def play(self): # 5 pts
        "Gère les animations du jeu"

        # Permet de lancer une nouvelle partie ou mettre en pause/redémarrer une partie en cours
        # En cas de lancement d'une nouvelle partie:
        #   Inscrire le nom des joueurs et leurs scores respectifs dans la partie supérieure de la fenêtre
        #   Détruire la zone d'inscription et la remplacer par l'image du logo du tournoi
        #   Mettre le gestionnaire d'animation du jeu à 0
        # En cas de démarrage d'une partie en cours:
        #   Mettre chaque balle du jeu en mouvement
        #   Modifier l'étiquette de texte située dans la partie inférieure de la fenêtre
        #   ainsi que le nom du bouton démarrage/pause
        #   Relancer le chronomètre du jeu
        # En cas de mise en pause d'une partie en cours:
        #   Arrêter le mouvement des balles
        #   Modifier l'étiquette de texte située dans la partie inférieure de la fenêtre
        #   ainsi que le nom du bouton démarrage/pause



    def end_it(self): # 2.5 pts
        "Clot le jeu proprement"

        # Détermine le gagnant en fonction du nom de points de chaque joueur
        # Met à jour la zone de texte située dans la partie inférieure de la fenêtre
        # Efface le contenu de l'aire de jeu et la remplace par l'image du trophé
        # Détruit le bouton interrupteur du jeu


    def chrono(self): # 2.5 pts
        "Lance le chronomètre du jeu"

        # Chaque seconde, incrémente le compteur de temps d'une unité
        # Toutes les 12 secondes, lance une nouvelle balle dans l'aire de jeu,
        # ajoute 3 points à chaque joueur et augmente la vitesse de chaque balle
        # de 1/9 de la vitesse précédente. 

            
class Balle(object):
    "Définition d'une balle animée dans un canevas"

    coul = ['white', 'red', 'blue', 'yellow', 'pink']
    compteur = 0

    def __init__(self, master, x=200, y = 126, rayon = 10, dx = 7, dy = 3, time = 100): # 1 pt

        # Références aux objets avec lesquels une balle interagit (fenêtre principale et canevas):
        self.master = 
        self.can = 

        # Caractéristiques d'une balle:
        self.x, self.y =                    # coordonnées (<x>;<y>) du centre de la balle
        self.rayon =                        # <rayon> de la balle
        self.dx =                           # composante <dx> du vecteur vitesse dont le sens est choisi aléatoirement à l'aide de la méthode <randint>
        self.dy =                           # composantes <dy> du vecteur vitesse dont le sens est choisi aléatoirement à l'aide de la méthode <randint>
        self.time =                         # temps <time> entre chaque déplacement
        
        
        # Création de la balle dans le canevas de jeu.
        # Sa couleur est déterminée par la valeur du compteur <Balle.compteur>
        self.canref = 

        # Incrémentation du compteur de balles construites
        Balle.compteur += 1


    def move(self): # 4.5 pts
        "Déplacement de la balle dans le canevas"

        # Tant que le gestionnaire d'animation du jeu est allumé, déplace la balle
        # dans l'aire de jeu en le faisant rebondir contre les parois supérieure et inférieure.
        # Lorsque le rebond se fait contre la raquette d'un joueur, ce dernier remporte 1 pt.
        # Lorsque un joueur ne parvient pas à faire rebondir la balle contre sa raquette,
        # il perd 4 pts, son adversaire en gagne 1 et la balle disparaît de l'aire de jeu.
        # Gère la mise à jour des étiquettes indiquant le nombre de points de chaque joueur
        # et transmet la main à la méthode end_it lorsqu'une des conditions de fin de partie
        # est satisfaite.


class Raquette(object):
    "Définition d'une raquette animée par l'utilisateur"

    def __init__(self, master, x, y, haut, bas, width = 20, height = 50): # 1 pt

        # Références aux objets avec lesquels une raquette interagit (fenêtre principale et canevas):
        self.master = 
        self.can = 

        # Caractéristiques d'une raquette:
        self.x, self.y =                            # coordonnées (<x>;<y>)du point supérieur gauche
        self.largeur, self.hauteur =                # dimensions de la raquette
        self.deplacement = 10                       # pas du déplacement
        self.haut = haut                            # événement pour monter
        self.bas = bas                              # événement pour descendre

        # Création de la raquette blanche dans le canevas de jeu                                                    
        self.canref = 
                                            

        # Points associés au joueur:
        self.points = 5

        # Liaison des événements haut et bas au gestionnaire <deplacer>
        self.master.bind('<'+self.haut+'>', self.deplacer)
        self.master.bind('<'+self.bas+'>', self.deplacer)

    def deplacer(self, event): # 1.5 pt
        "Déplacer verticalement la raquette"

        # Permet de déplacer la raquette verticalement vers le haut et le bas
        # en fonction de la touche (haut ou bas) sur laquelle a appuyé le joueur
        # associé à la raquette. Ce déplacement ne peut se faire que si la place
        # restante dans le canevas le permet et que si la partie n'est pas en pause.


# Corps principal du programme

Application().mainloop()

# Total: 23 pts
