# -*- encoding:utf8 -*-

# Fichier : modPendu.py
# Auteur : Jérôme Charrière
# Date : Avril 2021
# Version : 1.1
# Description :
#
# Module implémentant les différentes fonctions nécessaires à la réalisation
# du programme JeuPendu.

# Nouveautés de la version 1.1:

# Fonction permettant de sauvegarder les résultats de parties gagnantes
# Fonction permettant de trier les résultats acquis en fonction de leurs points associés

# Importation de fonctions nécessaires

from random import randint
from datetime import date


# Définition de fonctions

def choisirMot(nomFichier):
    """
    choisirMot(str nomFichier) --> str.
    Retourne de manière aléatoire un mot situé dans la fichier <nomFichier>
    """

    fichier = open(nomFichier, 'r', encoding='utf8')

    listeMots = fichier.readlines()

    fichier.close()

    index = randint(0, len(listeMots)-1)

    mot = listeMots[index][:-1]     # suppression du caractère de fin de ligne

    return mot



def affichePendu(PENDAISON, lettresIncorrectes, lettresCorrectes, motSecret):
    """
    affichePendu(list PENDAISON, list lettresIncorrectes, list lettresCorrectes, str motSecret) --> None.
    Affiche
    1) l'état du pendu situé dans la liste <PENDAISON>
    à l'aide du nombre de lettres incorrectes déjà proposées situées dans la liste <lettresIncorrectes>
    2) l'énumération des lettres incorrectes déjà proposées situées dans la liste <lettresIncorrectes>
    3) l'état de la recherche du <motSecret> à partir de la liste <lettresCorrectes> des lettres de <motSecret>
    déjà trouvées.
    
    """
    # Afficher l'état du pendu:
    print(PENDAISON[len(lettresIncorrectes)])
    print("\n")

    # Afficher la liste des lettres absentes du mot secret précédemment suggérées:
    print('Lettres absentes du mot secret:', end=' ')
    for lettre in lettresIncorrectes:
        print(lettre, end=' ')
    print("\n")

    # Afficher l'état du mot secret:
    etatMotSecret = '_' * len(motSecret)

    for i in range(len(motSecret)): # remplace les espaces (_) du mot secret par les lettres manquantes correctes
        if motSecret[i] in lettresCorrectes:
            etatMotSecret = etatMotSecret[:i] + motSecret[i] + etatMotSecret[i+1:]

    print("Etat du mot secret:", end=' ')
    for lettre in etatMotSecret: # montre l'état actuel du mot secret avec un espace entre chaque lettre
        print(lettre, end=' ')
    print("\n")

    
def proposer(dejapropose):
    """
    proposer(list dejapropose) --> str.
    Invite le joueur à proposer une lettre et la retourne après s'etre assuré que
    1) le joueur a bien entré une seule lettre et pas autre chose;
    2) la lettre entrée n'est pas située dans la liste <dejapropose> des lettres déjà suggérées lors d'un précédent appel
    """

    while 1:

        # Inviter l'utilisateur à entrer une lettre
        proposition = input("Proposez une lettre: ").lower()

        # Contrôler si la proposition est un seul caractère:
        if len(proposition) != 1:
            print('Entrez une seule lettre, s.v.p.')

        # Contrôler si la proposition a déjà été suggérée:
        elif proposition in dejapropose:
            print('Vous avez déjà fait cette suggestion. Choisissez une autre lettre.')

        # Contrôler si la proposition est un caractère autorisé:
        elif proposition not in 'abcdefghijklmnopqrstuvwxyzâàéèêëîôûùç-':
            print('Entrez un caractère alphabétique, s.v.p.')

        # Retourner la proposition:
        else:
            return proposition


def rejouer():
    """
    rejouer() --> bool.
    Demande au joueur s'il veut rejouer et retourne
    1) True si le joueur veut rejouer
    2) False sinon
    """

    reponse = input("Voulez-vous jouer une nouvelle partie ? (oui ou non): ").lower()
    if reponse[0] == 'o':
        return True
    else:
        return False

def creerSauvegarde(pseudo):
    """
    creerSauvegarde(str pseudo) --> None
    Crée, s'il n'existe pas, un fichier nommé 'pseudo.txt' dans le sous-dossier 'joueurs' du répertoire 'annexes'
    et y inscrit en première ligne le titre "Résultats de pseudo".
    """

    nomFichier = "annexes/joueurs/"+pseudo+'.txt'

    try:        # tente l'ouverture en mode lecture afin de savoir si le fichier existe
        fichier = open(nomFichier, 'r', encoding='utf8')
        
    except:     # crée le fichier s'il n'existe pas
        fichier = open(nomFichier, 'w', encoding='utf8')
        fichier.write("Résultats de "+ pseudo + ":\n")
        fichier.close()
        
    else:
        fichier.close()


def sauvegarder(pseudo, motCherche, points):
    """
    sauvegarder(str pseudo, str motCherche, int points) --> None
    Enregistre sur une seule ligne du fichier associé à pseudo le nombre de <points>
    réalisé lors de la recherche du <motCherche> au format suivant:

    date(26/3/2021):motCherche@points
    """

    nomFichier = "annexes/joueurs/"+pseudo+'.txt'
    fichier = open(nomFichier, 'a', encoding='utf8')

    today = date.today()        # récupération de la date d'aujourd'hui

    ligne = '{date}:{mot}@{pts}\n'.\
            format(date=str(today.day)+'/'+str(today.month)+'/'+str(today.year),\
                   mot = motCherche,\
                   pts = points)

    fichier.write(ligne)

    fichier.close()

    
def trierScores(pseudo):
    """
    trierScores(str pseudo) --> list
    Récupère tous les scores situés dans chacune des lignes du fichier associé à
    <pseudo> et retourne la liste de ces scores sous forme de tuples (points, mot, date)
    triée en fonction du nombre de points
    """
    
    nomFichier = "annexes/joueurs/"+pseudo+'.txt' 
    fichier = open(nomFichier, 'r', encoding='utf8')

    resultats = []

    fichier.readline()                                      # la première ligne contient le titre

    score = fichier.readline()

    while score != "":
        date = score.split(":")[0]                          # récupère la date
        mot = (score.split(":")[1]).split("@")[0]           # récupère le mot
        points = (score.split(":")[1]).split("@")[1][:-1]   # récupère les points associés
        
        resultats.append((int(points), mot, date))               # ajoute le tuple (points, mot, date) à la liste
        
        score = fichier.readline()

    fichier.close()

    resultats.sort()
    resultats.reverse()                                     # trie la liste de manière décroissante

    return resultats