# -*- encoding:utf8 -*-

# Fichier : jeuPendu.py
# Auteur : Jérôme Charrière
# Date : Avril 2021
# Version : 1.1
# Description :

# Ce module réalise un jeu du pendu simple qui choisit un nom d'animal
# aléatoirement, le mémorise et interroge ensuite l'utilisateur qui
# doit essayer de deviner le mot à l'aide de plusieurs essais
# successifs. Pour chaque lettre proposée, jeuPendu vérifie si la
# lettre se situe dans le mot secret et donne à l'utilisateur un
# feed-back. Ce feedback comporte la liste des lettres proposées
# incorrectes et celle des lettres proposées correctes. Le tout est
# agrémenté de l'affichage successif d'un pendu à chaque mauvaise
# réponse donnée par le joueur.

# Nouveautés de la version 1.1:

# Inscription des résultats de chaque partie gagnante dans un fichier annexe
# Visualisation des 3 meilleurs résultats réalisés


# Importation de fonctions nécessaires

from modPendu import *

#### Corps principal du programme ####

print('JEU DU PENDU\n')

# Inscription au jeu et création d'un fichier de résultat associé

pseudo = input('Entrez votre pseudo: ')
print('\n')

creerSauvegarde(pseudo)

# Présentation du jeu

print("Le mot secret est un nom d'animal")
print("Entrez une lettre. Si elle est dans le mot secret, elle sera affichée mais sinon...")
print("... la sentence se rapprochera !")

# Configuration du jeu: variables globales au programme

PENDAISON = ['''

  +---+
  |   |
      |
      |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
      |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
  |   |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|   |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
 /    |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
 / \  |
      |
=========''']                       # états du pendu

motsAchoix = 'annexes/mots.txt'     # nom du fichier contenant les mots à trouver

lettresIncorrectes = []             # liste des lettres proposées incorrectes
lettresCorrectes = []               # liste des lettres proposées correctes

motSecret = choisirMot(motsAchoix)  # mot secret à trouver

jeuTermine = False                  # état du jeu

# Déroulement du jeu:

while not jeuTermine:
    
    # Afficher l'état du jeu:
    affichePendu(PENDAISON, lettresIncorrectes, lettresCorrectes, motSecret)

    # Choix d'une lettre par le joueur:
    proposition = proposer(lettresIncorrectes + lettresCorrectes)

    # Si la proposition est située dans le motSecret,
    # 1) la rajouter à la liste des lettresCorrectes
    # 2) controler si le joueur a gagné, c'est-à-dire trouvé toutes les lettres
    if proposition in motSecret:
        lettresCorrectes.append(proposition)

        # Contrôler si le joueur à gagner:
        tousTrouve = True
        for i in range(len(motSecret)):
            if motSecret[i] not in lettresCorrectes:
                tousTrouve = False
                break
        if tousTrouve:
            print('Bravo! Le mot secret est "' + motSecret + '"! Vous avez gagné !')
            totalEssais = len(lettresCorrectes + lettresIncorrectes)
            essaisGagnants = len(lettresCorrectes)
            points = (essaisGagnants*100)//totalEssais
            sauvegarder(pseudo, motSecret, points)
            jeuTermine = True

    # Si la proposition n'est pas située dans le motSecret,
    # 1) la rajouter à la liste des lettresIncorrectes
    # 2) controler si le joueur a perdu, c'est-à-dire si la pendaison est atteinte
    else:
        lettresIncorrectes.append(proposition)

        # Contrôler si le joueur a perdu:
        if len(lettresIncorrectes) == len(PENDAISON) - 1:
            affichePendu(PENDAISON, lettresIncorrectes, lettresCorrectes, motSecret)
            print('Vous avez perdu !\nVous aviez pourtant trouvé ' + str(len(lettresCorrectes)) + ' lettre(s) correcte(s)...\n\
Le mot secret était: "' + motSecret + '"')
            jeuTermine = True

    # Demander au joueur s'il veut rejouer:
    if jeuTermine:
        if rejouer():
            # Relancer une nouvelle partie
            lettresIncorrectes = []
            lettresCorrectes = []
            jeuTermine = False
            motSecret = choisirMot(motsAchoix)            
            

# Afficher les meilleurs scores du joueur:
print("\nVoici la liste de vos actuels meilleurs scores:\n")

scores = trierScores(pseudo)

print("{:<3} \t {:^10} \t {:^10} \t {:>10}".format('Rang', 'Date', 'Mot', 'Points'))

i = 0
while i < 3 and i < len(scores):
    ligne = "{rang:<3} \t {date:^10} \t {mot:^10} \t {points:>10}".format(rang=i+1, date=scores[i][2], mot=scores[i][1], points=scores[i][0])
    print(ligne)
    i += 1

# Message d'au revoir:
print("Merci pour votre intérêt et à bientôt !")

input("Appuyez sur une touche pour fermer la fenetre!")
