# -*- encoding:utf8 -*-

# Fichier : jeuPendu.py
# Auteur : à compléter
# Date : Mars 2021
# Version : 1.0
# Description :

# Ce module réalise un jeu du pendu simple qui choisit un nom d'animal
# aléatoirement, le mémorise et interroge ensuite l'utilisateur qui
# doit essayer de deviner le mot à l'aide de plusieurs essais
# successifs. Pour chaque lettre proposée, jeuPendu vérifie si la
# lettre se situe dans le mot secret et donne à l'utilisateur un
# feed-back. Ce feedback comporte la liste des lettres proposées
# incorrectes et celle des lettres proposées correctes. Le tout est
# agrémenté de l'affichage successif d'un pendu à chaque mauvaise
# réponse donnée par le joueur.


# Importation de fonctions nécessaires

from modPendu import *


# Corps principal du programme:

print('JEU DU PENDU')
print("Le mot secret est un nom d'animal")
print("Entrez une lettre. Si elle est dans le mot secret, elle sera affichée mais sinon...")
print("... la sentence se rapprochera !")

# Configuration du jeu: variables globales au programme

PENDAISON = ['''

  +---+
  |   |
      |
      |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
      |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
  |   |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|   |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
      |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
 /    |
      |
=========''', '''

  +---+
  |   |
  O   |
 /|\  |
 / \  |
      |
=========''']                       # états du pendu

motsAchoix = 'annexes/mots.txt'     # nom du fichier contenant les mots à trouver

lettresIncorrectes = []             # liste des lettres proposées incorrectes
lettresCorrectes = []               # liste des lettres proposées correctes

motSecret = choisirMot(motsAchoix)  # mot secret à trouver
jeuTermine = False                  # état du jeu

# Déroulement du jeu:

while not jeuTermine:
    
    # Afficher l'état du jeu:
    # à compléter

    # Choix d'une lettre par le joueur:
    proposition = # à compléter

    
    # Si la proposition est située dans <motSecret>:
    # A compléter    
        # 1) la rajouter à la liste <lettresCorrectes>
        # A compléter

        # 2) controler si le joueur a gagné, c'est-à-dire trouvé toutes les lettres
        tousTrouve = True

        # A compléter

        if tousTrouve:
            print('Bravo! Le mot secret est "' + motSecret + '"! Vous avez gagné !')
            jeuTermine = True

    # Si la proposition n'est pas située dans le motSecret:
    # A compléter
    
        # 1) la rajouter à la liste <lettresIncorrectes>
        # A compléter

        # 2) controler si le joueur a perdu, c'est-à-dire si la pendaison est atteinte
        # et si tel est le cas, afficher l'état du pendu, un message indiquant le nombre
        # de lettres correctes trouvées ainsi que le mot secret et mettre l'interrupteur
        # <jeuTermine> à True
        # A compléter
    

    # Demander au joueur s'il veut rejouer:
    if jeuTermine:
        if rejouer():
            # Relancer une nouvelle partie
            lettresIncorrectes = []
            lettresCorrectes = []
            jeuTermine = False
            motSecret = choisirMot(motsAchoix)            
            

print("Merci pour votre intérêt et à bientôt !")           
